/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.scalar;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.cactoos.BiFunc;
import org.cactoos.Scalar;
import org.cactoos.iterable.Mapped;
import org.cactoos.scalar.Constant;

public final class Reduced<T>
implements Scalar<T> {
    private final Iterable<Scalar<T>> items;
    private final BiFunc<T, T, T> function;

    public Reduced(BiFunc<T, T, T> reduce, Iterable<Scalar<T>> scalars) {
        this.items = scalars;
        this.function = reduce;
    }

    @SafeVarargs
    public Reduced(BiFunc<T, T, T> reduce, T ... values) {
        this(reduce, (Iterable<Scalar<T>>)new Mapped<Object, Scalar>(Constant::new, values));
    }

    @Override
    public T value() throws Exception {
        Iterator<Scalar<T>> iter = this.items.iterator();
        if (!iter.hasNext()) {
            throw new NoSuchElementException("Can't find first element in an empty iterable");
        }
        T acc = iter.next().value();
        while (iter.hasNext()) {
            T next = iter.next().value();
            acc = this.function.apply(acc, next);
        }
        return acc;
    }
}

