/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.scalar;

import java.util.Comparator;
import java.util.Map;
import org.cactoos.Func;
import org.cactoos.Scalar;
import org.cactoos.iterator.Filtered;
import org.cactoos.iterator.Sorted;
import org.cactoos.map.MapOf;
import org.cactoos.scalar.Equals;
import org.cactoos.scalar.FallbackFrom;
import org.cactoos.scalar.Not;

public final class ScalarWithFallback<T>
implements Scalar<T> {
    private final Scalar<T> origin;
    private final Iterable<FallbackFrom<T>> fallbacks;
    private final Func<T, T> follow;

    public ScalarWithFallback(Scalar<T> origin, Iterable<FallbackFrom<T>> fbks, Func<T, T> follow) {
        this.origin = origin;
        this.fallbacks = fbks;
        this.follow = follow;
    }

    @Override
    public T value() throws Exception {
        T result;
        try {
            result = this.origin.value();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            result = this.fallback(ex);
        }
        catch (Throwable ex) {
            result = this.fallback(ex);
        }
        return this.follow.apply(result);
    }

    private T fallback(Throwable exp) throws Exception {
        Sorted candidates = new Sorted(Comparator.comparing(Map.Entry::getValue), new Filtered(entry -> new Not(new Equals<Integer>(entry::getValue, () -> Integer.MIN_VALUE)).value(), new MapOf<FallbackFrom, Integer>(fbk -> fbk, fbk -> fbk.support(exp.getClass()), this.fallbacks).entrySet().iterator()));
        if (candidates.hasNext()) {
            return ((FallbackFrom)candidates.next().getKey()).apply(exp);
        }
        throw new Exception("No fallback found - throw the original exception", exp);
    }
}

