/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.text;

import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.Locale;
import org.cactoos.Text;
import org.cactoos.list.ListOf;
import org.cactoos.text.TextOf;

public final class FormattedText
implements Text {
    private final Text pattern;
    private final Collection<Object> args;
    private final Locale locale;

    public FormattedText(String ptn, Object ... arguments) {
        this(ptn, new ListOf<Object>(arguments));
    }

    public FormattedText(Text ptn, Object ... arguments) {
        this(ptn, new ListOf<Object>(arguments));
    }

    public FormattedText(String ptn, Locale locale, Object ... arguments) {
        this(ptn, locale, new ListOf<Object>(arguments));
    }

    public FormattedText(Text ptn, Locale locale, Object ... arguments) {
        this(ptn, locale, new ListOf<Object>(arguments));
    }

    public FormattedText(String ptn, Collection<Object> arguments) {
        this(ptn, Locale.getDefault(Locale.Category.FORMAT), arguments);
    }

    public FormattedText(Text ptn, Collection<Object> arguments) {
        this(ptn, Locale.getDefault(Locale.Category.FORMAT), arguments);
    }

    public FormattedText(String ptn, Locale locale, Collection<Object> arguments) {
        this((Text)new TextOf(ptn), locale, arguments);
    }

    public FormattedText(Text ptn, Locale locale, Collection<Object> arguments) {
        this.pattern = ptn;
        this.locale = locale;
        this.args = Collections.unmodifiableCollection(arguments);
    }

    @Override
    public String asString() throws Exception {
        StringBuilder out = new StringBuilder(0);
        try (Formatter fmt = new Formatter(out, this.locale);){
            fmt.format(this.pattern.asString(), this.args.toArray(new Object[0]));
        }
        return out.toString();
    }
}

