/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.text;

import java.security.SecureRandom;
import java.util.List;
import java.util.Random;
import org.cactoos.Scalar;
import org.cactoos.Text;
import org.cactoos.list.ListOf;
import org.cactoos.scalar.UncheckedScalar;

public final class RandomText
implements Text {
    private static final int MAX_RANDOM_LENGTH = 255;
    private final List<Character> characters;
    private final Scalar<Integer> length;
    private final Random random;

    public RandomText() {
        this(() -> new SecureRandom().nextInt(254) + 1);
    }

    public RandomText(Integer len) {
        this(() -> len);
    }

    public RandomText(Scalar<Integer> len) {
        this(new ListOf<Character>(Character.valueOf('!'), Character.valueOf('\"'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('&'), Character.valueOf('\''), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf(','), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('/'), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf(':'), Character.valueOf(';'), Character.valueOf('<'), Character.valueOf('='), Character.valueOf('>'), Character.valueOf('?'), Character.valueOf('@'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf('['), Character.valueOf('\\'), Character.valueOf(']'), Character.valueOf('^'), Character.valueOf('_'), Character.valueOf('`'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('{'), Character.valueOf('|'), Character.valueOf('}'), Character.valueOf('~')), len);
    }

    public RandomText(Character ... chrs) {
        this(new ListOf<Character>(chrs));
    }

    public RandomText(List<Character> chrs) {
        this(chrs, () -> new SecureRandom().nextInt(254) + 1);
    }

    public RandomText(Integer len, Character ... chrs) {
        this(() -> len, chrs);
    }

    public RandomText(Scalar<Integer> len, Character ... chrs) {
        this(new ListOf<Character>(chrs), len);
    }

    public RandomText(List<Character> chrs, Scalar<Integer> len) {
        this(chrs, len, new SecureRandom());
    }

    public RandomText(List<Character> chrs, Scalar<Integer> len, Random rnd) {
        this.characters = chrs;
        this.length = len;
        this.random = rnd;
    }

    @Override
    public String asString() {
        int len = new UncheckedScalar<Integer>(this.length).value();
        StringBuilder builder = new StringBuilder(len);
        int bound = this.characters.size();
        for (int index = 0; index < len; ++index) {
            builder.append(this.characters.get(this.random.nextInt(bound)));
        }
        return builder.toString();
    }
}

