/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.text;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.cactoos.Bytes;
import org.cactoos.Input;
import org.cactoos.Scalar;
import org.cactoos.io.BytesOf;
import org.cactoos.io.InputOf;
import org.cactoos.iterable.Mapped;
import org.cactoos.text.JoinedText;
import org.cactoos.text.TextEnvelope;

public final class TextOf
extends TextEnvelope {
    public TextOf(Input input) {
        this(new BytesOf(input));
    }

    public TextOf(URL url) {
        this(new InputOf(url));
    }

    public TextOf(URI uri) {
        this(new InputOf(uri));
    }

    public TextOf(Path path) {
        this(new InputOf(path));
    }

    public TextOf(File file) {
        this(new InputOf(file));
    }

    public TextOf(Input input, int max) {
        this(input, max, StandardCharsets.UTF_8);
    }

    public TextOf(Input input, Charset cset) {
        this((Bytes)new BytesOf(input), cset);
    }

    public TextOf(Input input, String cset) {
        this((Bytes)new BytesOf(input), cset);
    }

    public TextOf(Input input, int max, Charset cset) {
        this((Bytes)new BytesOf(input, max), cset);
    }

    public TextOf(Reader rdr) {
        this(new BytesOf(rdr));
    }

    public TextOf(Reader rdr, Charset cset) {
        this(new BytesOf(rdr, cset));
    }

    public TextOf(Reader rdr, int max, Charset cset) {
        this(new BytesOf(rdr, cset, max));
    }

    public TextOf(CharSequence builder) {
        this(new BytesOf(builder));
    }

    public TextOf(CharSequence builder, Charset cset) {
        this((Bytes)new BytesOf(builder, cset), cset);
    }

    public TextOf(char ... chars) {
        this(new BytesOf(chars));
    }

    public TextOf(char[] chars, Charset cset) {
        this(new BytesOf(chars, cset));
    }

    public TextOf(Throwable error) {
        this(new BytesOf(error));
    }

    public TextOf(Throwable error, Charset charset) {
        this(new BytesOf(error, charset));
    }

    public TextOf(Throwable error, CharSequence charset) {
        this(new BytesOf(error, charset));
    }

    public TextOf(StackTraceElement ... strace) {
        this(new BytesOf(strace));
    }

    public TextOf(StackTraceElement[] strace, Charset charset) {
        this(new BytesOf(strace, charset));
    }

    public TextOf(StackTraceElement[] strace, CharSequence charset) {
        this(new BytesOf(strace, charset));
    }

    public TextOf(byte ... bytes) {
        this(new BytesOf(bytes));
    }

    public TextOf(Bytes bytes) {
        this(bytes, StandardCharsets.UTF_8);
    }

    public TextOf(Bytes bytes, Charset cset) {
        this(() -> new String(bytes.asBytes(), cset));
    }

    public TextOf(Bytes bytes, String cset) {
        this(() -> new String(bytes.asBytes(), cset));
    }

    public TextOf(String input) {
        this(input, StandardCharsets.UTF_8);
    }

    public TextOf(String input, Charset cset) {
        this(() -> new String(input.getBytes(cset), cset));
    }

    public TextOf(Iterable<?> iterable) {
        this(() -> new JoinedText(", ", new Mapped<Object, String>(Object::toString, iterable)).asString());
    }

    public TextOf(InputStream input) {
        this(new InputOf(new InputStreamReader(input, StandardCharsets.UTF_8)));
    }

    private TextOf(Scalar<String> scalar) {
        super(scalar);
    }
}

