/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.time;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import org.cactoos.text.TextEnvelope;
import org.cactoos.time.Iso;
import org.cactoos.time.ZonedDateTimeAsText;

public final class DateAsText
extends TextEnvelope {
    public DateAsText() {
        this(System.currentTimeMillis());
    }

    public DateAsText(long milliseconds) {
        this(Date.from(Instant.ofEpochMilli(milliseconds)), new Iso().get());
    }

    public DateAsText(long milliseconds, String format) {
        this(Date.from(Instant.ofEpochMilli(milliseconds)), format, Locale.getDefault(Locale.Category.FORMAT));
    }

    public DateAsText(long milliseconds, String format, Locale locale) {
        this(Date.from(Instant.ofEpochMilli(milliseconds)), DateTimeFormatter.ofPattern(format, locale));
    }

    public DateAsText(Date date) {
        this(date, new Iso().get());
    }

    public DateAsText(Date date, String format) {
        this(date, format, Locale.getDefault(Locale.Category.FORMAT));
    }

    public DateAsText(Date date, String format, Locale locale) {
        this(date, DateTimeFormatter.ofPattern(format, locale));
    }

    public DateAsText(Date date, DateTimeFormatter formatter) {
        super(() -> new ZonedDateTimeAsText(ZonedDateTime.ofInstant(date.toInstant(), ZoneId.of("UTC")), formatter).asString());
    }
}

