/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.time;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.cactoos.text.TextEnvelope;
import org.cactoos.time.Iso;

public final class LocalDateTimeAsText
extends TextEnvelope {
    public LocalDateTimeAsText(LocalDateTime date) {
        this(date, new Iso().get());
    }

    public LocalDateTimeAsText(LocalDateTime date, String format) {
        this(date, format, Locale.getDefault(Locale.Category.FORMAT));
    }

    public LocalDateTimeAsText(LocalDateTime date, String format, Locale locale) {
        this(date, DateTimeFormatter.ofPattern(format, locale));
    }

    public LocalDateTimeAsText(LocalDateTime date, DateTimeFormatter formatter) {
        super(() -> formatter.format(date.atZone(ZoneId.systemDefault())));
    }
}

