/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.takes.Request;
import org.takes.Response;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.Pass;
import org.takes.misc.Opt;

public final class PsAll
implements Pass {
    private final List<? extends Pass> all;
    private final int index;

    public PsAll(List<? extends Pass> passes, int identity) {
        this.all = new ArrayList<Pass>(passes);
        this.index = this.validated(identity);
    }

    @Override
    public Opt<Identity> enter(Request request) throws Exception {
        Opt<Identity> result = this.allMatch(request) ? this.all.get(this.index).enter(request) : new Opt.Empty<Identity>();
        return result;
    }

    @Override
    public Response exit(Response response, Identity identity) throws Exception {
        if (this.index >= this.all.size()) {
            throw new IOException("Index of identity is greater than Pass collection size");
        }
        return this.all.get(this.index).exit(response, identity);
    }

    private int validated(int idx) {
        if (idx < 0) {
            throw new IllegalArgumentException(String.format("Index %d must be >= 0.", idx));
        }
        if (idx >= this.all.size()) {
            throw new IllegalArgumentException(String.format("Trying to return index %d from a list of %d passes", idx, this.all.size()));
        }
        return idx;
    }

    private boolean allMatch(Request request) throws Exception {
        boolean success = true;
        for (Pass pass : this.all) {
            if (pass.enter(request).has()) continue;
            success = false;
            break;
        }
        return success;
    }
}

