/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.cactoos.text.TrimmedText;
import org.cactoos.text.UncheckedText;
import org.takes.Request;
import org.takes.Response;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.Pass;
import org.takes.facets.flash.RsFlash;
import org.takes.facets.forward.RsForward;
import org.takes.misc.Opt;
import org.takes.misc.Utf8String;
import org.takes.rq.RqHeaders;
import org.takes.rq.RqHref;
import org.takes.rs.RsWithHeader;

public final class PsBasic
implements Pass {
    private static final Pattern AUTH = Pattern.compile("Basic");
    private final Entry entry;
    private final String realm;

    public PsBasic(String rlm, Entry basic) {
        this.realm = rlm;
        this.entry = basic;
    }

    @Override
    public Opt<Identity> enter(Request request) throws IOException {
        Iterator<String> headers = new RqHeaders.Smart(new RqHeaders.Base(request)).header("authorization").iterator();
        if (!headers.hasNext()) {
            throw new RsForward(new RsWithHeader(String.format("WWW-Authenticate: Basic ream=\"%s\" ", this.realm)), 401, (CharSequence)new RqHref.Base(request).href());
        }
        String decoded = new UncheckedText(new TrimmedText(new Utf8String(DatatypeConverter.parseBase64Binary(AUTH.split(headers.next())[1])))).asString();
        String user = decoded.split(":")[0];
        Opt<Identity> identity = this.entry.enter(user, decoded.substring(user.length() + 1));
        if (!identity.has()) {
            throw new RsForward(new RsWithHeader(new RsFlash((CharSequence)"access denied", Level.WARNING), (CharSequence)String.format("WWW-Authenticate: Basic ream=\"%s\"", this.realm)), 401, (CharSequence)new RqHref.Base(request).href());
        }
        return identity;
    }

    @Override
    public Response exit(Response response, Identity identity) {
        return response;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PsBasic)) {
            return false;
        }
        PsBasic other = (PsBasic)o;
        Entry this$entry = this.entry;
        Entry other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        String this$realm = this.realm;
        String other$realm = other.realm;
        return !(this$realm == null ? other$realm != null : !this$realm.equals(other$realm));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Entry $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        String $realm = this.realm;
        result = result * 59 + ($realm == null ? 43 : $realm.hashCode());
        return result;
    }

    public static final class Default
    implements Entry {
        private static final String KEY_FORMAT = "%s %s";
        private static final String ENCODING = "UTF-8";
        private final Map<String, String> usernames;

        public Default(String ... users) {
            this.usernames = Default.converted(users);
        }

        @Override
        public Opt<Identity> enter(String user, String pwd) {
            Opt<Identity> identity;
            Opt<String> urn = this.urn(user, pwd);
            if (urn.has()) {
                try {
                    identity = new Opt.Single<Identity.Simple>(new Identity.Simple(URLDecoder.decode(urn.get(), ENCODING)));
                }
                catch (UnsupportedEncodingException ex) {
                    throw new IllegalStateException(ex);
                }
            } else {
                identity = new Opt.Empty<Identity>();
            }
            return identity;
        }

        private static Map<String, String> converted(String ... users) {
            HashMap<String, String> result = new HashMap<String, String>(users.length);
            for (String user : users) {
                String unified = user.replace("%20", "+");
                Default.validateUser(unified);
                result.put(Default.key(unified), unified.substring(unified.lastIndexOf(32) + 1));
            }
            return result;
        }

        private Opt<String> urn(String user, String pwd) {
            String urn;
            try {
                urn = this.usernames.get(String.format(KEY_FORMAT, URLEncoder.encode(user, ENCODING), URLEncoder.encode(pwd, ENCODING)));
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException(ex);
            }
            Opt<Object> opt = urn == null ? new Opt.Empty() : new Opt.Single<String>(urn);
            return opt;
        }

        private static String key(String unified) {
            return String.format(KEY_FORMAT, unified.substring(0, unified.indexOf(32)), unified.substring(unified.indexOf(32) + 1, unified.lastIndexOf(32)));
        }

        private static void validateUser(String unified) {
            boolean nearby;
            boolean amount = Default.countSpaces(unified) != 2;
            boolean bl = nearby = unified.indexOf(32) + 1 == unified.lastIndexOf(32);
            if (amount || nearby) {
                throw new IllegalArgumentException(String.format("One of users was incorrectly formatted: %s", unified));
            }
        }

        private static int countSpaces(String txt) {
            int spaces = 0;
            for (char character : txt.toCharArray()) {
                if (character != ' ') continue;
                ++spaces;
            }
            return spaces;
        }
    }

    public static final class Empty
    implements Entry {
        @Override
        public Opt<Identity> enter(String user, String pwd) {
            return new Opt.Empty<Identity>();
        }
    }

    public static final class Fake
    implements Entry {
        private final boolean condition;

        public Fake(boolean cond) {
            this.condition = cond;
        }

        @Override
        public Opt<Identity> enter(String usr, String pwd) {
            Opt<Identity> user = this.condition ? new Opt.Single<Identity.Simple>(new Identity.Simple(String.format("urn:basic:%s", usr))) : new Opt.Empty<Identity>();
            return user;
        }
    }

    public static interface Entry {
        public Opt<Identity> enter(String var1, String var2);
    }
}

