/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth.codecs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.codecs.Codec;
import org.takes.facets.auth.codecs.DecodingException;

public final class CcBase64
implements Codec {
    private static final String BASE64CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    private final Codec origin;

    public CcBase64(Codec codec) {
        this.origin = codec;
    }

    @Override
    public byte[] encode(Identity identity) throws IOException {
        return Base64.getEncoder().encode(this.origin.encode(identity));
    }

    @Override
    public Identity decode(byte[] bytes) throws IOException {
        byte[] illegal = CcBase64.checkIllegalCharacters(bytes);
        if (illegal.length > 0) {
            throw new DecodingException(String.format("Illegal character in Base64 encoded data. %s", Arrays.toString(illegal)));
        }
        return this.origin.decode(Base64.getDecoder().decode(bytes));
    }

    private static byte[] checkIllegalCharacters(byte[] bytes) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (byte byt : bytes) {
            if (BASE64CHARS.indexOf(byt) >= 0) continue;
            out.write(byt);
        }
        return out.toByteArray();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CcBase64)) {
            return false;
        }
        CcBase64 other = (CcBase64)o;
        Codec this$origin = this.origin;
        Codec other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Codec $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }
}

