/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth.codecs;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Random;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.codecs.Codec;
import org.takes.facets.auth.codecs.DecodingException;

public final class CcSalted
implements Codec {
    private static final Random RND = new SecureRandom();
    private final Codec origin;

    public CcSalted(Codec codec) {
        this.origin = codec;
    }

    @Override
    public byte[] encode(Identity identity) throws IOException {
        return CcSalted.salt(this.origin.encode(identity));
    }

    @Override
    public Identity decode(byte[] bytes) throws IOException {
        return this.origin.decode(CcSalted.unsalt(bytes));
    }

    private static byte[] salt(byte[] text) {
        int size = RND.nextInt(10);
        byte[] output = new byte[text.length + size + 2];
        output[0] = size;
        byte sum = 0;
        for (int idx = 0; idx < size; ++idx) {
            output[idx + 1] = (byte)RND.nextInt();
            sum = (byte)(sum + output[idx + 1]);
        }
        System.arraycopy(text, 0, output, size + 1, text.length);
        output[output.length - 1] = sum;
        return output;
    }

    private static byte[] unsalt(byte[] text) {
        if (text.length == 0) {
            throw new DecodingException("empty input");
        }
        int size = text[0];
        if (size < 0) {
            throw new DecodingException(String.format("Length of salt %+d is negative, something is wrong", size));
        }
        if (text.length < size + 2) {
            throw new DecodingException(String.format("Not enough bytes for salt, length is %d while %d required", text.length, size + 2));
        }
        byte sum = 0;
        for (int idx = 0; idx < size; ++idx) {
            sum = (byte)(sum + text[idx + 1]);
        }
        if (text[text.length - 1] != sum) {
            throw new DecodingException(String.format("Checksum %d failure, while %d expected", text[text.length - 1], sum));
        }
        byte[] output = new byte[text.length - size - 2];
        System.arraycopy(text, size + 1, output, 0, output.length);
        return output;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CcSalted)) {
            return false;
        }
        CcSalted other = (CcSalted)o;
        Codec this$origin = this.origin;
        Codec other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Codec $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }
}

