/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth.codecs;

import java.io.IOException;
import java.util.Arrays;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.codecs.Codec;
import org.takes.misc.Utf8String;

public final class CcXor
implements Codec {
    private final Codec origin;
    private final byte[] secret;

    public CcXor(Codec codec, String key) {
        this(codec, new Utf8String(key).asBytes());
    }

    public CcXor(Codec codec, byte[] key) {
        this.origin = codec;
        this.secret = Arrays.copyOf(key, key.length);
    }

    @Override
    public byte[] encode(Identity identity) throws IOException {
        return this.xor(this.origin.encode(identity));
    }

    @Override
    public Identity decode(byte[] bytes) throws IOException {
        return this.origin.decode(this.xor(bytes));
    }

    private byte[] xor(byte[] input) {
        byte[] output = new byte[input.length];
        if (this.secret.length == 0) {
            System.arraycopy(input, 0, output, 0, input.length);
        } else {
            int spos = 0;
            for (int pos = 0; pos < input.length; ++pos) {
                output[pos] = (byte)(input[pos] ^ this.secret[spos]);
                if (++spos < this.secret.length) continue;
                spos = 0;
            }
        }
        return output;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CcXor)) {
            return false;
        }
        CcXor other = (CcXor)o;
        Codec this$origin = this.origin;
        Codec other$origin = other.origin;
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        return Arrays.equals(this.secret, other.secret);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Codec $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        result = result * 59 + Arrays.hashCode(this.secret);
        return result;
    }
}

