/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth.social;

import com.jcabi.http.request.JdkRequest;
import com.jcabi.http.response.RestResponse;
import com.restfb.DefaultFacebookClient;
import com.restfb.DefaultJsonMapper;
import com.restfb.DefaultWebRequestor;
import com.restfb.JsonMapper;
import com.restfb.Parameter;
import com.restfb.Version;
import com.restfb.WebRequestor;
import com.restfb.exception.FacebookException;
import com.restfb.types.User;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import org.takes.HttpException;
import org.takes.Request;
import org.takes.Response;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.Pass;
import org.takes.misc.Href;
import org.takes.misc.Opt;
import org.takes.rq.RqHref;

public final class PsFacebook
implements Pass {
    private static final String CLIENT_ID = "client_id";
    private static final String CLIENT_SECRET = "client_secret";
    private static final String CODE = "code";
    private static final String PICTURE = "picture";
    private static final String ACCESS_TOKEN_URL = "https://graph.facebook.com/oauth/access_token";
    private final com.jcabi.http.Request request;
    private final WebRequestor requestor;
    private final String app;
    private final String key;

    public PsFacebook(String fapp, String fkey) {
        this((com.jcabi.http.Request)new JdkRequest(new Href(ACCESS_TOKEN_URL).with(CLIENT_ID, fapp).with(CLIENT_SECRET, fkey).toString()), (WebRequestor)new DefaultWebRequestor(), fapp, fkey);
    }

    PsFacebook(com.jcabi.http.Request frequest, WebRequestor frequestor, String fapp, String fkey) {
        this.request = frequest;
        this.requestor = frequestor;
        this.app = fapp;
        this.key = fkey;
    }

    @Override
    public Opt<Identity> enter(Request trequest) throws IOException {
        Href href = new RqHref.Base(trequest).href();
        Iterator<String> code = href.param(CODE).iterator();
        if (!code.hasNext()) {
            throw new HttpException(400, "code is not provided by Facebook");
        }
        User user = this.fetch(this.token(href.toString(), code.next()));
        HashMap<String, String> props = new HashMap<String, String>(0);
        props.put("name", user.getName());
        props.put(PICTURE, new Href("https://graph.facebook.com/").path(user.getId()).path(PICTURE).toString());
        return new Opt.Single<Identity>(new Identity.Simple(String.format("urn:facebook:%s", user.getId()), props));
    }

    @Override
    public Response exit(Response response, Identity identity) {
        return response;
    }

    private User fetch(String token) {
        try {
            return (User)new DefaultFacebookClient(token, this.requestor, (JsonMapper)new DefaultJsonMapper(), Version.LATEST).fetchObject("me", User.class, new Parameter[0]);
        }
        catch (FacebookException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private String token(String home, String code) throws IOException {
        String[] sectors;
        String response = ((RestResponse)this.request.uri().set(URI.create(new Href(ACCESS_TOKEN_URL).with(CLIENT_ID, this.app).with("redirect_uri", home).with(CLIENT_SECRET, this.key).with(CODE, code).toString())).back().fetch().as(RestResponse.class)).assertStatus(200).body();
        for (String sector : sectors = response.split("&")) {
            String[] pair = sector.split("=");
            if (pair.length != 2) {
                throw new IllegalArgumentException(String.format("Invalid response: '%s'", response));
            }
            if (!"access_token".equals(pair[0])) continue;
            return pair[1];
        }
        throw new IllegalArgumentException(String.format("Access token not found in response: '%s'", response));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PsFacebook)) {
            return false;
        }
        PsFacebook other = (PsFacebook)o;
        String this$app = this.app;
        String other$app = other.app;
        if (this$app == null ? other$app != null : !this$app.equals(other$app)) {
            return false;
        }
        String this$key = this.key;
        String other$key = other.key;
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $app = this.app;
        result = result * 59 + ($app == null ? 43 : $app.hashCode());
        String $key = this.key;
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }
}

