/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth.social;

import com.jcabi.http.request.JdkRequest;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import com.jcabi.http.response.XmlResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.json.JsonObject;
import org.takes.HttpException;
import org.takes.Request;
import org.takes.Response;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.Pass;
import org.takes.misc.Href;
import org.takes.misc.Opt;
import org.takes.rq.RqHref;

public final class PsGithub
implements Pass {
    private static final String ACCESS_TOKEN = "access_token";
    private static final String CODE = "code";
    private static final String LOGIN = "login";
    private final String app;
    private final String key;
    private final String github;
    private final String api;

    public PsGithub(String gapp, String gkey) {
        this(gapp, gkey, "https://github.com", "https://api.github.com");
    }

    PsGithub(String gapp, String gkey, String gurl, String aurl) {
        this.app = gapp;
        this.key = gkey;
        this.github = gurl;
        this.api = aurl;
    }

    @Override
    public Opt<Identity> enter(Request request) throws IOException {
        Href href = new RqHref.Base(request).href();
        Iterator<String> code = href.param(CODE).iterator();
        if (!code.hasNext()) {
            throw new HttpException(400, "code is not provided by Github");
        }
        return new Opt.Single<Identity>(this.fetch(this.token(href.toString(), code.next())));
    }

    @Override
    public Response exit(Response response, Identity identity) {
        return response;
    }

    private Identity fetch(String token) throws IOException {
        String uri = new Href(this.api).path("user").with(ACCESS_TOKEN, token).toString();
        return PsGithub.parse(((JsonResponse)((RestResponse)new JdkRequest(uri).header("accept", (Object)"application/json").fetch().as(RestResponse.class)).assertStatus(200).as(JsonResponse.class)).json().readObject());
    }

    private String token(String home, String code) throws IOException {
        String uri = new Href(this.github).path(LOGIN).path("oauth").path(ACCESS_TOKEN).toString();
        return (String)((XmlResponse)((RestResponse)new JdkRequest(uri).method("POST").header("Accept", (Object)"application/xml").body().formParam("client_id", (Object)this.app).formParam("redirect_uri", (Object)home).formParam("client_secret", (Object)this.key).formParam(CODE, (Object)code).back().fetch().as(RestResponse.class)).assertStatus(200).as(XmlResponse.class)).assertXPath("/OAuth/access_token").xml().xpath("/OAuth/access_token/text()").get(0);
    }

    private static Identity parse(JsonObject json) {
        HashMap<String, String> props = new HashMap<String, String>(json.size());
        props.put(LOGIN, json.getString(LOGIN, "unknown"));
        props.put("avatar", json.getString("avatar_url", "#"));
        return new Identity.Simple(String.format("urn:github:%d", json.getInt("id")), props);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PsGithub)) {
            return false;
        }
        PsGithub other = (PsGithub)o;
        String this$app = this.app;
        String other$app = other.app;
        if (this$app == null ? other$app != null : !this$app.equals(other$app)) {
            return false;
        }
        String this$key = this.key;
        String other$key = other.key;
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $app = this.app;
        result = result * 59 + ($app == null ? 43 : $app.hashCode());
        String $key = this.key;
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }
}

