/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth.social;

import com.jcabi.http.request.JdkRequest;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.json.JsonObject;
import org.takes.HttpException;
import org.takes.Request;
import org.takes.Response;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.Pass;
import org.takes.misc.Href;
import org.takes.misc.Opt;
import org.takes.rq.RqHref;

public final class PsLinkedin
implements Pass {
    private static final String CODE = "code";
    private final String app;
    private final String key;
    private final Href tkhref;
    private final Href apihref;

    public PsLinkedin(String lapp, String lkey) {
        this(new Href("https://www.linkedin.com/uas/oauth2/accessToken"), new Href("https://api.linkedin.com/v1/people/~:(id,first-name,last-name,picture-url)"), lapp, lkey);
    }

    public PsLinkedin(Href thref, Href ahref, String lapp, String lkey) {
        this.tkhref = thref;
        this.apihref = ahref;
        this.app = lapp;
        this.key = lkey;
    }

    @Override
    public Opt<Identity> enter(Request request) throws IOException {
        Href href = new RqHref.Base(request).href();
        Iterator<String> code = href.param(CODE).iterator();
        if (!code.hasNext()) {
            throw new HttpException(400, "code is not provided by LinkedIn");
        }
        return new Opt.Single<Identity>(this.fetch(this.token(href.toString(), code.next())));
    }

    @Override
    public Response exit(Response response, Identity identity) {
        return response;
    }

    private Identity fetch(String token) throws IOException {
        String uri = this.apihref.with("oauth2_access_token", token).with("format", "json").toString();
        return PsLinkedin.parse(((JsonResponse)((RestResponse)new JdkRequest(uri).header("accept", (Object)"application/json").fetch().as(RestResponse.class)).assertStatus(200).as(JsonResponse.class)).json().readObject());
    }

    private String token(String home, String code) throws IOException {
        String uri = this.tkhref.toString();
        return ((JsonResponse)((RestResponse)new JdkRequest(uri).method("POST").header("Accept", (Object)"application/xml").body().formParam("grant_type", (Object)"authorization_code").formParam("client_id", (Object)this.app).formParam("redirect_uri", (Object)home).formParam("client_secret", (Object)this.key).formParam(CODE, (Object)code).back().fetch().as(RestResponse.class)).assertStatus(200).as(JsonResponse.class)).json().readObject().getString("access_token");
    }

    private static Identity parse(JsonObject json) {
        String fname = "firstName";
        String lname = "lastName";
        String unknown = "?";
        HashMap<String, String> props = new HashMap<String, String>(json.size());
        props.put("firstName", json.getString("firstName", "?"));
        props.put("lastName", json.getString("lastName", "?"));
        return new Identity.Simple(String.format("urn:linkedin:%s", json.getString("id")), props);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PsLinkedin)) {
            return false;
        }
        PsLinkedin other = (PsLinkedin)o;
        String this$app = this.app;
        String other$app = other.app;
        if (this$app == null ? other$app != null : !this$app.equals(other$app)) {
            return false;
        }
        String this$key = this.key;
        String other$key = other.key;
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $app = this.app;
        result = result * 59 + ($app == null ? 43 : $app.hashCode());
        String $key = this.key;
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }
}

