/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.cookies;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.takes.Request;
import org.takes.misc.EnglishLowerCase;
import org.takes.misc.Sprintf;
import org.takes.misc.VerboseIterable;
import org.takes.rq.RqHeaders;
import org.takes.rq.RqWrap;

public interface RqCookies
extends Request {
    public Iterable<String> cookie(CharSequence var1) throws IOException;

    public Iterable<String> names() throws IOException;

    public static final class Base
    extends RqWrap
    implements RqCookies {
        public Base(Request req) {
            super(req);
        }

        @Override
        public Iterable<String> cookie(CharSequence key) throws IOException {
            Map<String, String> map = this.map();
            String value = map.getOrDefault(new EnglishLowerCase(key.toString()).string(), "");
            VerboseIterable<String> iter = value.isEmpty() ? new VerboseIterable(Collections.emptyList(), new Sprintf("There are no Cookies by name \"%s\" among %d others: %s", key, map.size(), map.keySet())) : new VerboseIterable<String>(Collections.singleton(value), new Sprintf("There is always only one Cookie by name \"%s\"", key));
            return iter;
        }

        @Override
        public Iterable<String> names() throws IOException {
            return this.map().keySet();
        }

        private Map<String, String> map() throws IOException {
            HashMap<String, String> map = new HashMap<String, String>(0);
            List<String> values = new RqHeaders.Base(this).header("Cookie");
            for (String value : values) {
                for (String pair : value.split(";")) {
                    String[] parts = pair.split("=", 2);
                    String key = new EnglishLowerCase(parts[0].trim()).string();
                    if (parts.length > 1 && !parts[1].isEmpty()) {
                        map.put(key, parts[1].trim());
                        continue;
                    }
                    map.remove(key);
                }
            }
            return map;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Base)) {
                return false;
            }
            Base other = (Base)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Base;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            return result;
        }
    }
}

