/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.cookies;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.takes.Request;
import org.takes.Response;
import org.takes.Take;
import org.takes.rs.RsWithHeader;
import org.takes.rs.RsWithoutHeader;
import org.takes.tk.TkWrap;

public final class TkJoinedCookies
extends TkWrap {
    private static final Pattern PTN = Pattern.compile("set-cookie: (.+)", 2);

    public TkJoinedCookies(final Take take) {
        super(new Take(){

            @Override
            public Response act(Request req) throws Exception {
                return TkJoinedCookies.join(take.act(req));
            }
        });
    }

    private static Response join(Response response) throws Exception {
        StringBuilder cookies = new StringBuilder();
        for (String header : response.head()) {
            Matcher matcher = PTN.matcher(header);
            if (!matcher.matches()) continue;
            cookies.append(matcher.group(1)).append(", ");
        }
        Response out = cookies.length() > 0 ? new RsWithHeader(new RsWithoutHeader(response, "Set-cookie"), "Set-Cookie", cookies.toString()) : response;
        return out;
    }

    @Override
    public String toString() {
        return "TkJoinedCookies(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TkJoinedCookies)) {
            return false;
        }
        TkJoinedCookies other = (TkJoinedCookies)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TkJoinedCookies;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

