/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.fork;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.takes.HttpException;
import org.takes.Request;
import org.takes.Response;
import org.takes.facets.fork.Fork;
import org.takes.misc.Opt;
import org.takes.rs.RsWrap;

public final class RsFork
extends RsWrap {
    public RsFork(Request req, Fork ... list) {
        this(req, Arrays.asList(list));
    }

    public RsFork(final Request req, final Iterable<Fork> list) {
        super(new Response(){

            @Override
            public Iterable<String> head() throws IOException {
                return RsFork.pick(req, list).head();
            }

            @Override
            public InputStream body() throws IOException {
                return RsFork.pick(req, list).body();
            }
        });
    }

    private static Response pick(Request req, Iterable<Fork> forks) throws IOException {
        for (Fork fork : forks) {
            try {
                Opt<Response> rsps = fork.route(req);
                if (!rsps.has()) continue;
                return rsps.get();
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        throw new HttpException(404);
    }

    @Override
    public String toString() {
        return "RsFork(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RsFork)) {
            return false;
        }
        RsFork other = (RsFork)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RsFork;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

