/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.forward;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.takes.Request;
import org.takes.Response;
import org.takes.Take;
import org.takes.facets.forward.RsForward;
import org.takes.rs.RsSimple;

public final class TkForward
implements Take {
    private final Take origin;

    public TkForward(Take take) {
        this.origin = take;
    }

    @Override
    public Response act(Request req) throws Exception {
        Response res;
        try {
            res = this.origin.act(req);
        }
        catch (RsForward ex) {
            res = ex;
        }
        return new Safe(res);
    }

    public String toString() {
        return "TkForward(origin=" + this.origin + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TkForward)) {
            return false;
        }
        TkForward other = (TkForward)o;
        Take this$origin = this.origin;
        Take other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Take $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }

    private static final class Safe
    implements Response {
        private final Response origin;
        private final List<Response> saved;

        private Safe(Response res) {
            this.origin = res;
            this.saved = new CopyOnWriteArrayList<Response>();
        }

        @Override
        public Iterable<String> head() throws IOException {
            return this.load().head();
        }

        @Override
        public InputStream body() throws IOException {
            return this.load().body();
        }

        private Response load() throws IOException {
            if (this.saved.isEmpty()) {
                InputStream body;
                Iterable<String> head;
                try {
                    head = this.origin.head();
                    body = this.origin.body();
                }
                catch (RsForward ex) {
                    head = ex.head();
                    body = ex.body();
                }
                this.saved.add(new RsSimple(head, body));
            }
            return this.saved.get(0);
        }

        public String toString() {
            return "TkForward.Safe(origin=" + this.origin + ", saved=" + this.saved + ")";
        }
    }
}

