/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.hamcrest;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.takes.Body;

public final class HmBody<T extends Body>
extends TypeSafeMatcher<T> {
    private final InputStream body;

    public HmBody(String value) {
        this(value, Charset.defaultCharset());
    }

    public HmBody(String value, Charset charset) {
        this(value.getBytes(charset));
    }

    public HmBody(byte[] value) {
        this(new ByteArrayInputStream(value));
    }

    public HmBody(InputStream value) {
        this.body = value;
    }

    public void describeTo(Description description) {
        try {
            description.appendText("body: ").appendText(Arrays.toString(HmBody.asBytes(this.body)));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void describeMismatchSafely(T item, Description description) {
        try {
            description.appendText("body was: ").appendText(Arrays.toString(HmBody.asBytes(HmBody.itemBody(item))));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public boolean matchesSafely(T item) {
        boolean result = true;
        try (BufferedInputStream val = new BufferedInputStream(HmBody.itemBody(item));){
            int right;
            int left = this.body.read();
            while (left != -1) {
                right = ((InputStream)val).read();
                if (left != right) {
                    result = false;
                    break;
                }
                left = this.body.read();
            }
            right = ((InputStream)val).read();
            if (result) {
                result = right == -1;
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return result;
    }

    private static InputStream itemBody(Body item) throws IOException {
        return item.body();
    }

    private static byte[] asBytes(InputStream input) throws IOException {
        input.reset();
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int read;
            byte[] buffer = new byte[1024];
            while ((read = input.read(buffer, 0, buffer.length)) != -1) {
                output.write(buffer, 0, read);
            }
            output.flush();
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }
}

