/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.hamcrest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.takes.Head;

public final class HmHeader<T extends Head>
extends TypeSafeMatcher<T> {
    private static final String VALUES_STR = " -> values: ";
    private final Matcher<String> header;
    private final Matcher<Iterable<String>> value;
    private Collection<String> failed;

    public HmHeader(Matcher<String> hdrm, Matcher<Iterable<String>> vlm) {
        this.header = hdrm;
        this.value = vlm;
    }

    public HmHeader(String hdr, Matcher<Iterable<String>> vlm) {
        this((Matcher<String>)Matchers.equalToIgnoringCase((String)hdr), vlm);
    }

    public HmHeader(String hdr, String val) {
        this((Matcher<String>)Matchers.equalToIgnoringCase((String)hdr), (Matcher<Iterable<String>>)Matchers.hasItems((Object[])new String[]{val}));
    }

    public void describeTo(Description description) {
        description.appendText("header: ").appendDescriptionOf(this.header).appendText(VALUES_STR).appendDescriptionOf(this.value);
    }

    public boolean matchesSafely(T item) {
        try {
            Iterator<String> headers = HmHeader.headers(item).iterator();
            ArrayList<String> values = new ArrayList<String>(0);
            while (headers.hasNext()) {
                String[] parts = HmHeader.split(headers.next());
                if (!this.header.matches((Object)parts[0].trim())) continue;
                values.add(parts[1].trim());
            }
            boolean result = this.value.matches(values);
            if (!result) {
                this.failed = values;
            }
            return result;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void describeMismatchSafely(T item, Description description) {
        description.appendText("header was: ").appendDescriptionOf(this.header).appendText(VALUES_STR).appendValue(this.failed);
    }

    private static Iterable<String> headers(Head item) throws IOException {
        return item.head();
    }

    private static String[] split(String header) {
        return header.split(":", 2);
    }
}

