/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.ret;

import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.takes.Request;
import org.takes.Response;
import org.takes.Take;
import org.takes.facets.cookies.RqCookies;
import org.takes.facets.cookies.RsWithCookie;
import org.takes.facets.ret.RsReturn;
import org.takes.rs.RsRedirect;

public final class TkReturn
implements Take {
    private final Take origin;
    private final String cookie;

    public TkReturn(Take take) {
        this(take, RsReturn.class.getSimpleName());
    }

    public TkReturn(Take take, String name) {
        this.origin = take;
        this.cookie = name;
    }

    @Override
    public Response act(Request request) throws Exception {
        RqCookies.Base cookies = new RqCookies.Base(request);
        Iterator<String> values = cookies.cookie(this.cookie).iterator();
        Response response = values.hasNext() ? new RsWithCookie(new RsRedirect(URLDecoder.decode(values.next(), Charset.defaultCharset().name())), (CharSequence)this.cookie, (CharSequence)"", new CharSequence[0]) : this.origin.act(request);
        return response;
    }

    public String toString() {
        return "TkReturn(origin=" + this.origin + ", cookie=" + this.cookie + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TkReturn)) {
            return false;
        }
        TkReturn other = (TkReturn)o;
        Take this$origin = this.origin;
        Take other$origin = other.origin;
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        String this$cookie = this.cookie;
        String other$cookie = other.cookie;
        return !(this$cookie == null ? other$cookie != null : !this$cookie.equals(other$cookie));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Take $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        String $cookie = this.cookie;
        result = result * 59 + ($cookie == null ? 43 : $cookie.hashCode());
        return result;
    }
}

