/*
 * Decompiled with CFR 0.152.
 */
package org.takes.http;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.takes.HttpException;
import org.takes.Request;
import org.takes.Response;
import org.takes.Take;
import org.takes.http.Back;
import org.takes.misc.Utf8PrintStream;
import org.takes.rq.RqLive;
import org.takes.rq.RqWithHeaders;
import org.takes.rs.RsPrint;
import org.takes.rs.RsText;
import org.takes.rs.RsWithStatus;

public final class BkBasic
implements Back {
    public static final String LOCALADDR = "X-Takes-LocalAddress";
    public static final String LOCALPORT = "X-Takes-LocalPort";
    public static final String REMOTEADDR = "X-Takes-RemoteAddress";
    public static final String REMOTEPORT = "X-Takes-RemotePort";
    private final Take take;

    public BkBasic(Take tks) {
        this.take = tks;
    }

    @Override
    public void accept(Socket socket) throws IOException {
        try (InputStream input = socket.getInputStream();
             BufferedOutputStream output = new BufferedOutputStream(socket.getOutputStream());){
            do {
                this.print(BkBasic.addSocketHeaders(new RqLive(input), socket), output);
            } while (input.available() > 0);
        }
    }

    private void print(Request req, OutputStream output) throws IOException {
        try {
            new RsPrint(this.take.act(req)).print(output);
        }
        catch (HttpException ex) {
            new RsPrint(BkBasic.failure(ex, ex.code())).print(output);
        }
        catch (Throwable ex) {
            new RsPrint(BkBasic.failure(ex, 500)).print(output);
        }
    }

    private static Response failure(Throwable err, int code) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (Utf8PrintStream stream = new Utf8PrintStream(baos, false);){
            err.printStackTrace(stream);
        }
        return new RsWithStatus(new RsText(new ByteArrayInputStream(baos.toByteArray())), code);
    }

    private static Request addSocketHeaders(Request req, Socket socket) {
        return new RqWithHeaders(req, String.format("%s: %s", LOCALADDR, socket.getLocalAddress().getHostAddress()), String.format("%s: %d", LOCALPORT, socket.getLocalPort()), String.format("%s: %s", REMOTEADDR, socket.getInetAddress().getHostAddress()), String.format("%s: %d", REMOTEADDR, socket.getPort()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BkBasic)) {
            return false;
        }
        BkBasic other = (BkBasic)o;
        Take this$take = this.take;
        Take other$take = other.take;
        return !(this$take == null ? other$take != null : !this$take.equals(other$take));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Take $take = this.take;
        result = result * 59 + ($take == null ? 43 : $take.hashCode());
        return result;
    }
}

