/*
 * Decompiled with CFR 0.152.
 */
package org.takes.http;

import java.io.IOException;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.takes.http.Back;

public final class BkTimeable
extends Thread
implements Back {
    private final Back back;
    private final long latency;
    private final ConcurrentMap<Thread, Long> threads = new ConcurrentHashMap<Thread, Long>(1);

    public BkTimeable(Back back, long msec) {
        this.back = back;
        this.latency = msec;
    }

    @Override
    public void run() {
        while (true) {
            this.check();
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(ex);
            }
        }
    }

    @Override
    public void accept(Socket socket) throws IOException {
        this.threads.put(Thread.currentThread(), System.currentTimeMillis());
        this.back.accept(socket);
    }

    private void check() {
        for (Map.Entry entry : this.threads.entrySet()) {
            long time = System.currentTimeMillis();
            if (time - (Long)entry.getValue() <= this.latency) continue;
            Thread thread = (Thread)entry.getKey();
            if (thread.isAlive()) {
                thread.interrupt();
            }
            this.threads.remove(thread);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BkTimeable)) {
            return false;
        }
        BkTimeable other = (BkTimeable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Back this$back = this.back;
        Back other$back = other.back;
        if (this$back == null ? other$back != null : !this$back.equals(other$back)) {
            return false;
        }
        if (this.latency != other.latency) {
            return false;
        }
        ConcurrentMap<Thread, Long> this$threads = this.threads;
        ConcurrentMap<Thread, Long> other$threads = other.threads;
        return !(this$threads == null ? other$threads != null : !this$threads.equals(other$threads));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BkTimeable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Back $back = this.back;
        result = result * 59 + ($back == null ? 43 : $back.hashCode());
        long $latency = this.latency;
        result = result * 59 + (int)($latency >>> 32 ^ $latency);
        ConcurrentMap<Thread, Long> $threads = this.threads;
        result = result * 59 + ($threads == null ? 43 : $threads.hashCode());
        return result;
    }
}

