/*
 * Decompiled with CFR 0.152.
 */
package org.takes.http;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.takes.Take;
import org.takes.http.Back;
import org.takes.http.BkBasic;
import org.takes.http.BkParallel;
import org.takes.http.Exit;
import org.takes.http.Front;
import org.takes.http.FtBasic;

public final class FtRemote
implements Front {
    private final Front origin;
    private final ServerSocket socket;
    private final boolean secured;

    public FtRemote(Take tks) throws IOException {
        this(new BkParallel(new BkBasic(tks)));
    }

    public FtRemote(Back bck) throws IOException {
        this(bck, FtRemote.random());
    }

    public FtRemote(Back bck, ServerSocket skt) {
        this(new FtBasic(bck, skt), skt, false);
    }

    FtRemote(Front front, ServerSocket skt, boolean sec) {
        this.origin = front;
        this.socket = skt;
        this.secured = sec;
    }

    @Override
    public void start(Exit exit) throws IOException {
        this.origin.start(exit);
    }

    public void exec(Script script) throws Exception {
        final AtomicBoolean exit = new AtomicBoolean();
        final CountDownLatch latch = new CountDownLatch(1);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    FtRemote.this.start(new Exit(){

                        @Override
                        public boolean ready() {
                            latch.countDown();
                            return exit.get();
                        }
                    });
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        });
        thread.start();
        try {
            if (!latch.await(10L, TimeUnit.SECONDS)) {
                throw new IllegalArgumentException("failed to start the app");
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ex);
        }
        String protocol = this.secured ? "https" : "http";
        script.exec(URI.create(String.format("%s://localhost:%d", protocol, this.socket.getLocalPort())));
        exit.set(true);
        try {
            thread.join();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ex);
        }
    }

    private static ServerSocket random() throws IOException {
        ServerSocket skt = new ServerSocket(0);
        skt.setReuseAddress(true);
        return skt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FtRemote)) {
            return false;
        }
        FtRemote other = (FtRemote)o;
        Front this$origin = this.origin;
        Front other$origin = other.origin;
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        ServerSocket this$socket = this.socket;
        ServerSocket other$socket = other.socket;
        if (this$socket == null ? other$socket != null : !this$socket.equals(other$socket)) {
            return false;
        }
        return this.secured == other.secured;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Front $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        ServerSocket $socket = this.socket;
        result = result * 59 + ($socket == null ? 43 : $socket.hashCode());
        result = result * 59 + (this.secured ? 79 : 97);
        return result;
    }

    public static interface Script {
        public void exec(URI var1) throws Exception;
    }
}

