/*
 * Decompiled with CFR 0.152.
 */
package org.takes.misc;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;

public final class Sprintf
implements CharSequence {
    private final String pattern;
    private final Collection<Object> args;

    public Sprintf(String ptn, Object ... arguments) {
        this(ptn, Arrays.asList(arguments));
    }

    public Sprintf(String ptn, Collection<Object> arguments) {
        this.pattern = ptn;
        this.args = Collections.unmodifiableCollection(arguments);
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder(0);
        try (Formatter fmt = new Formatter(out);){
            fmt.format(this.pattern, this.args.toArray(new Object[this.args.size()]));
            String string = out.toString();
            return string;
        }
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }
}

