/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rq;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.takes.Request;
import org.takes.rq.ChunkedInputStream;
import org.takes.rq.RqHeaders;
import org.takes.rq.RqWrap;

public final class RqChunk
extends RqWrap {
    public RqChunk(final Request req) {
        super(new Request(){

            @Override
            public Iterable<String> head() throws IOException {
                return req.head();
            }

            @Override
            public InputStream body() throws IOException {
                return RqChunk.cap(req);
            }
        });
    }

    private static InputStream cap(Request req) throws IOException {
        Iterator<String> hdr = new RqHeaders.Base(req).header("Transfer-Encoding").iterator();
        InputStream result = hdr.hasNext() && "chunked".equalsIgnoreCase(hdr.next()) ? new ChunkedInputStream(req.body()) : req.body();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RqChunk)) {
            return false;
        }
        RqChunk other = (RqChunk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RqChunk;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

