/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rq;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Iterator;
import org.takes.HttpException;
import org.takes.Request;
import org.takes.misc.Href;
import org.takes.rq.RqHeaders;
import org.takes.rq.RqRequestLine;
import org.takes.rq.RqWrap;

public interface RqHref
extends Request {
    public Href href() throws IOException;

    public static final class Smart
    implements RqHref {
        private final RqHref origin;

        public Smart(Request req) {
            this(new Base(req));
        }

        public Smart(RqHref req) {
            this.origin = req;
        }

        @Override
        public Href href() throws IOException {
            return this.origin.href();
        }

        @Override
        public Iterable<String> head() throws IOException {
            return this.origin.head();
        }

        @Override
        public InputStream body() throws IOException {
            return this.origin.body();
        }

        public Href home() throws IOException {
            URI full = URI.create(this.href().toString());
            return new Href(String.format("%s://%s/", full.getScheme(), full.getHost()));
        }

        public String single(CharSequence name) throws IOException {
            Iterator<String> params = this.href().param(name).iterator();
            if (!params.hasNext()) {
                throw new HttpException(400, String.format("query param \"%s\" is mandatory", name));
            }
            return params.next();
        }

        public String single(CharSequence name, CharSequence def) throws IOException {
            Iterator<String> params = this.href().param(name).iterator();
            String value = params.hasNext() ? params.next() : def.toString();
            return value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            RqHref this$origin = this.origin;
            RqHref other$origin = other.origin;
            return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RqHref $origin = this.origin;
            result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
            return result;
        }
    }

    public static final class Base
    extends RqWrap
    implements RqHref {
        public Base(Request req) {
            super(req);
        }

        @Override
        public Href href() throws IOException {
            String uri = new RqRequestLine.Base(this).uri();
            Iterator<String> hosts = new RqHeaders.Base(this).header("host").iterator();
            Iterator<String> protos = new RqHeaders.Base(this).header("x-forwarded-proto").iterator();
            String host = hosts.hasNext() ? hosts.next().trim() : "localhost";
            String proto = protos.hasNext() ? protos.next().trim() : "http";
            return new Href(String.format("%s://%s%s", proto, host, uri));
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Base)) {
                return false;
            }
            Base other = (Base)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Base;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            return result;
        }
    }
}

