/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rq;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.takes.Request;
import org.takes.rq.RqWrap;

public final class RqOnce
extends RqWrap {
    public RqOnce(Request req) {
        super(RqOnce.wrap(req));
    }

    private static Request wrap(final Request req) {
        final AtomicBoolean seen = new AtomicBoolean(false);
        return new Request(){

            @Override
            public Iterable<String> head() throws IOException {
                return req.head();
            }

            @Override
            public InputStream body() throws IOException {
                if (!seen.getAndSet(true)) {
                    throw new IllegalStateException("It's not allowed to call body() more than once");
                }
                return req.body();
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RqOnce)) {
            return false;
        }
        RqOnce other = (RqOnce)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RqOnce;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

