/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rq;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import org.takes.Request;
import org.takes.misc.Utf8OutputStreamContent;
import org.takes.misc.Utf8String;
import org.takes.rq.RqChunk;
import org.takes.rq.RqLengthAware;
import org.takes.rq.RqWrap;

public final class RqPrint
extends RqWrap {
    public RqPrint(Request req) {
        super(req);
    }

    public String print() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.print(baos);
        return new Utf8String(baos.toByteArray()).asString();
    }

    public void print(OutputStream output) throws IOException {
        this.printHead(output);
        this.printBody(output);
    }

    public String printHead() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.printHead(baos);
        return new Utf8String(baos.toByteArray()).asString();
    }

    public void printHead(OutputStream output) throws IOException {
        String eol = "\r\n";
        Utf8OutputStreamContent writer = new Utf8OutputStreamContent(output);
        for (String line : this.head()) {
            ((Writer)writer).append(line);
            ((Writer)writer).append("\r\n");
        }
        ((Writer)writer).append("\r\n");
        ((Writer)writer).flush();
    }

    public String printBody() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.printBody(baos);
        return new Utf8String(baos.toByteArray()).asString();
    }

    public void printBody(OutputStream output) throws IOException {
        int bytes;
        InputStream input = new RqChunk(new RqLengthAware(this)).body();
        byte[] buf = new byte[4096];
        while ((bytes = input.read(buf)) >= 0) {
            output.write(buf, 0, bytes);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RqPrint)) {
            return false;
        }
        RqPrint other = (RqPrint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RqPrint;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

