/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rq;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.takes.HttpException;
import org.takes.Request;
import org.takes.rq.RqWrap;

public interface RqRequestLine
extends Request {
    public String header() throws IOException;

    public String method() throws IOException;

    public String uri() throws IOException;

    public String version() throws IOException;

    public static final class Base
    extends RqWrap
    implements RqRequestLine {
        private static final String BAD_REQUEST_MSG = "Invalid HTTP Request-Line header: %s";
        private static final Pattern PATTERN = Pattern.compile("([!-~]+) ([^ ]+)( [^ ]+)?");

        public Base(Request req) {
            super(req);
        }

        @Override
        public String header() throws IOException {
            return Base.validated(this.line());
        }

        @Override
        public String method() throws IOException {
            return this.token(Token.METHOD);
        }

        @Override
        public String uri() throws IOException {
            return this.token(Token.URI);
        }

        @Override
        public String version() throws IOException {
            return this.token(Token.HTTPVERSION);
        }

        private String token(Token token) throws IOException {
            return Base.trimmed(Base.matcher(this.line()).group(token.value), token);
        }

        private String line() throws IOException {
            if (!this.head().iterator().hasNext()) {
                throw new HttpException(400, "HTTP Request should have Request-Line");
            }
            return this.head().iterator().next();
        }

        private static Matcher matcher(String line) throws HttpException {
            Matcher matcher = PATTERN.matcher(line);
            if (!matcher.matches()) {
                throw new HttpException(400, String.format(BAD_REQUEST_MSG, line));
            }
            return matcher;
        }

        private static String validated(String line) throws HttpException {
            if (!PATTERN.matcher(line).matches()) {
                throw new HttpException(400, String.format(BAD_REQUEST_MSG, line));
            }
            return line;
        }

        private static String trimmed(String value, Token token) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("There is no token %s in Request-Line header", token.toString()));
            }
            return value.trim();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Base)) {
                return false;
            }
            Base other = (Base)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Base;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            return result;
        }

        private static enum Token {
            METHOD(1),
            URI(2),
            HTTPVERSION(3);

            private final int value;

            private Token(int val) {
                this.value = val;
            }
        }
    }
}

