/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rq.form;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.takes.HttpException;
import org.takes.Request;
import org.takes.misc.EnglishLowerCase;
import org.takes.misc.Sprintf;
import org.takes.misc.VerboseIterable;
import org.takes.rq.RqForm;
import org.takes.rq.RqPrint;
import org.takes.rq.RqWrap;

public final class RqFormBase
extends RqWrap
implements RqForm {
    private final Request req;
    private final List<Map<String, List<String>>> saved = new CopyOnWriteArrayList<Map<String, List<String>>>();

    public RqFormBase(Request request) {
        super(request);
        this.req = request;
    }

    @Override
    public Iterable<String> param(CharSequence key) throws IOException {
        List values = this.map().getOrDefault(new EnglishLowerCase(key.toString()).string(), Collections.emptyList());
        VerboseIterable<String> iter = values.isEmpty() ? new VerboseIterable(Collections.emptyList(), new Sprintf("there are no params \"%s\" among %d others: %s", key, this.map().size(), this.map().keySet())) : new VerboseIterable<String>(values, new Sprintf("there are only %d params by name \"%s\"", values.size(), key));
        return iter;
    }

    @Override
    public Iterable<String> names() throws IOException {
        return this.map().keySet();
    }

    private static String decode(CharSequence txt) {
        try {
            return URLDecoder.decode(txt.toString(), Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private Map<String, List<String>> map() throws IOException {
        if (this.saved.isEmpty()) {
            this.saved.add(this.freshMap());
        }
        return this.saved.get(0);
    }

    private Map<String, List<String>> freshMap() throws IOException {
        String body = new RqPrint(this.req).printBody();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(1);
        for (String pair : body.split("&")) {
            if (pair.isEmpty()) continue;
            String[] parts = pair.split("=", 2);
            if (parts.length < 2) {
                throw new HttpException(400, String.format("invalid form body pair: %s", pair));
            }
            String key = RqFormBase.decode(new EnglishLowerCase(parts[0].trim()).string());
            if (!map.containsKey(key)) {
                map.put(key, new LinkedList());
            }
            ((List)map.get(key)).add(RqFormBase.decode(parts[1].trim()));
        }
        return map;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RqFormBase)) {
            return false;
        }
        RqFormBase other = (RqFormBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Request this$req = this.req;
        Request other$req = other.req;
        if (this$req == null ? other$req != null : !this$req.equals(other$req)) {
            return false;
        }
        List<Map<String, List<String>>> this$saved = this.saved;
        List<Map<String, List<String>>> other$saved = other.saved;
        return !(this$saved == null ? other$saved != null : !((Object)this$saved).equals(other$saved));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RqFormBase;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Request $req = this.req;
        result = result * 59 + ($req == null ? 43 : $req.hashCode());
        List<Map<String, List<String>>> $saved = this.saved;
        result = result * 59 + ($saved == null ? 43 : ((Object)$saved).hashCode());
        return result;
    }
}

