/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.GZIPOutputStream;
import org.takes.Response;
import org.takes.rs.RsWithBody;
import org.takes.rs.RsWithHeader;

public final class RsGzip
implements Response {
    private final Response origin;
    private final List<Response> zipped = new CopyOnWriteArrayList<Response>();

    public RsGzip(Response res) {
        this.origin = res;
    }

    @Override
    public Iterable<String> head() throws IOException {
        return this.make().head();
    }

    @Override
    public InputStream body() throws IOException {
        return this.make().body();
    }

    private Response make() throws IOException {
        if (this.zipped.isEmpty()) {
            this.zipped.add(new RsWithHeader(new RsWithBody(this.origin, RsGzip.gzip(this.origin.body())), "Content-Encoding", "gzip"));
        }
        return this.zipped.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] gzip(InputStream input) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        GZIPOutputStream gzip = new GZIPOutputStream(baos);
        try {
            int len;
            while ((len = input.read(buf)) >= 0) {
                ((OutputStream)gzip).write(buf, 0, len);
            }
        }
        finally {
            ((OutputStream)gzip).close();
            input.close();
        }
        return baos.toByteArray();
    }

    public String toString() {
        return "RsGzip(origin=" + this.origin + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RsGzip)) {
            return false;
        }
        RsGzip other = (RsGzip)o;
        Response this$origin = this.origin;
        Response other$origin = other.origin;
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        List<Response> this$zipped = this.zipped;
        List<Response> other$zipped = other.zipped;
        return !(this$zipped == null ? other$zipped != null : !((Object)this$zipped).equals(other$zipped));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Response $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        List<Response> $zipped = this.zipped;
        result = result * 59 + ($zipped == null ? 43 : ((Object)$zipped).hashCode());
        return result;
    }
}

