/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.takes.Response;
import org.takes.rs.RsWithBody;
import org.w3c.dom.DocumentType;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class RsPrettyXml
implements Response {
    private static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private final Response origin;
    private final List<Response> transformed = new CopyOnWriteArrayList<Response>();
    private final Object lock;

    public RsPrettyXml(Response res) {
        this.origin = res;
        this.lock = new Object();
    }

    @Override
    public Iterable<String> head() throws IOException {
        return this.make().head();
    }

    @Override
    public InputStream body() throws IOException {
        return this.make().body();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response make() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.transformed.isEmpty()) {
                this.transformed.add(new RsWithBody(this.origin, RsPrettyXml.transform(this.origin.body())));
            }
        }
        return this.transformed.get(0);
    }

    private static byte[] transform(InputStream body) throws IOException {
        SAXSource source = new SAXSource(new InputSource(body));
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            XMLReader xmlreader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            source.setXMLReader(xmlreader);
            xmlreader.setFeature(LOAD_EXTERNAL_DTD, false);
            String yes = "yes";
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            RsPrettyXml.prepareDocType(body, transformer);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, new StreamResult(result));
        }
        catch (ParserConfigurationException | TransformerException | SAXException ex) {
            throw new IOException(ex);
        }
        return result.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void prepareDocType(InputStream body, Transformer transformer) throws IOException {
        try {
            String html = "html";
            DocumentType doctype = RsPrettyXml.getDocType(body);
            if (null != doctype) {
                if (null == doctype.getSystemId() && null == doctype.getPublicId() && "html".equalsIgnoreCase(doctype.getName())) {
                    transformer.setOutputProperty("method", "html");
                    transformer.setOutputProperty("version", "5.0");
                    return;
                }
                if (null != doctype.getSystemId()) {
                    transformer.setOutputProperty("doctype-system", doctype.getSystemId());
                }
                if (null != doctype.getPublicId()) {
                    transformer.setOutputProperty("doctype-public", doctype.getPublicId());
                }
            }
        }
        finally {
            body.reset();
        }
    }

    private static DocumentType getDocType(InputStream body) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature(LOAD_EXTERNAL_DTD, false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(body).getDoctype();
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new IOException(ex);
        }
    }

    public String toString() {
        return "RsPrettyXml(origin=" + this.origin + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RsPrettyXml)) {
            return false;
        }
        RsPrettyXml other = (RsPrettyXml)o;
        Response this$origin = this.origin;
        Response other$origin = other.origin;
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        List<Response> this$transformed = this.transformed;
        List<Response> other$transformed = other.transformed;
        if (this$transformed == null ? other$transformed != null : !((Object)this$transformed).equals(other$transformed)) {
            return false;
        }
        Object this$lock = this.lock;
        Object other$lock = other.lock;
        return !(this$lock == null ? other$lock != null : !this$lock.equals(other$lock));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Response $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        List<Response> $transformed = this.transformed;
        result = result * 59 + ($transformed == null ? 43 : ((Object)$transformed).hashCode());
        Object $lock = this.lock;
        result = result * 59 + ($lock == null ? 43 : $lock.hashCode());
        return result;
    }
}

