/*
 * Decompiled with CFR 0.152.
 */
package org.takes.rs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.takes.Response;
import org.takes.Scalar;
import org.takes.misc.Utf8InputStreamContent;
import org.takes.misc.Utf8OutputStreamContent;
import org.takes.misc.Utf8String;
import org.takes.rs.RsEmpty;
import org.takes.rs.RsWrap;

public final class RsVelocity
extends RsWrap {
    public RsVelocity(CharSequence template, Pair ... params) {
        this((InputStream)new ByteArrayInputStream(new Utf8String(template.toString()).asBytes()), params);
    }

    public RsVelocity(URL template, Pair ... params) throws IOException {
        this(template.openStream(), params);
    }

    public RsVelocity(InputStream template, Pair ... params) {
        this(template, RsVelocity.asMap(params));
    }

    public RsVelocity(InputStream template, Map<CharSequence, Object> params) {
        this(".", template, params);
    }

    public RsVelocity(String folder, InputStream template, Map<CharSequence, Object> params) {
        this(folder, template, () -> RsVelocity.convert(params));
    }

    public RsVelocity(final String folder, final InputStream template, final Scalar<Map<String, Object>> params) {
        super(new Response(){

            @Override
            public Iterable<String> head() {
                return new RsEmpty().head();
            }

            @Override
            public InputStream body() throws IOException {
                return RsVelocity.render(folder, template, (Map)params.get());
            }
        });
    }

    private static InputStream render(String folder, InputStream template, Map<String, Object> params) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Utf8OutputStreamContent writer = new Utf8OutputStreamContent(baos);
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("file.resource.loader.path", (Object)folder);
        engine.evaluate((Context)new VelocityContext(params), (Writer)writer, "", (Reader)new Utf8InputStreamContent(template));
        ((Writer)writer).close();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    @SafeVarargs
    private static Map<CharSequence, Object> asMap(Map.Entry<CharSequence, Object> ... entries) {
        HashMap<CharSequence, Object> map = new HashMap<CharSequence, Object>(entries.length);
        for (Map.Entry<CharSequence, Object> ent : entries) {
            map.put(ent.getKey(), ent.getValue());
        }
        return map;
    }

    private static Map<String, Object> convert(Map<CharSequence, Object> params) {
        HashMap<String, Object> map = new HashMap<String, Object>(params.size());
        for (Map.Entry<CharSequence, Object> ent : params.entrySet()) {
            map.put(ent.getKey().toString(), ent.getValue());
        }
        return map;
    }

    @Override
    public String toString() {
        return "RsVelocity(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RsVelocity)) {
            return false;
        }
        RsVelocity other = (RsVelocity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RsVelocity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    public static final class Pair
    extends AbstractMap.SimpleEntry<CharSequence, Object> {
        private static final long serialVersionUID = 7362489770169963015L;

        public Pair(CharSequence key, Object obj) {
            super(key, obj);
        }
    }
}

