/*
 * Decompiled with CFR 0.152.
 */
package org.takes.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import org.takes.Request;

final class RqFrom
implements Request {
    private final HttpServletRequest sreq;

    RqFrom(HttpServletRequest request) {
        this.sreq = request;
    }

    @Override
    public Iterable<String> head() {
        LinkedList<String> head = new LinkedList<String>();
        head.add(new HttpHead(this.sreq).toString());
        ArrayList<String> names = Collections.list(this.sreq.getHeaderNames());
        if (!names.stream().anyMatch("host"::equalsIgnoreCase)) {
            head.add(new HttpHost(this.sreq).toString());
        }
        names.forEach(header -> head.add(String.format("%s: %s", header, this.sreq.getHeader(header))));
        head.add(String.format("X-Takes-LocalAddress: %s", this.sreq.getLocalAddr()));
        head.add(String.format("X-Takes-RemoteAddress: %s", this.sreq.getRemoteAddr()));
        return head;
    }

    @Override
    public InputStream body() throws IOException {
        return this.sreq.getInputStream();
    }

    private static final class HttpHost {
        private static final int PORT_DEFAULT = 80;
        private final HttpServletRequest req;

        private HttpHost(HttpServletRequest request) {
            this.req = request;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder(100);
            bld.append("Host: ").append(this.req.getServerName());
            int port = this.req.getServerPort();
            if (port != 80) {
                bld.append(':').append(port);
            }
            return bld.toString();
        }
    }

    private static final class HttpHead {
        private final HttpServletRequest req;

        HttpHead(HttpServletRequest request) {
            this.req = request;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder(20).append(this.req.getMethod()).append(' ');
            String uri = this.req.getRequestURI();
            if (uri == null) {
                bld.append('/');
            } else {
                bld.append(uri);
            }
            String query = this.req.getQueryString();
            if (query != null) {
                bld.append('?').append(query);
            }
            return bld.toString();
        }
    }
}

