/*
 * Decompiled with CFR 0.152.
 */
package org.takes.tk;

import java.io.IOException;
import java.io.InputStream;
import org.takes.HttpException;
import org.takes.Request;
import org.takes.Response;
import org.takes.Take;
import org.takes.rq.RqHref;
import org.takes.rs.RsWithBody;
import org.takes.tk.TkWrap;

public final class TkClasspath
extends TkWrap {
    public TkClasspath() {
        this("");
    }

    public TkClasspath(Class<?> base) {
        this(String.format("/%s", base.getPackage().getName().replace(".", "/")));
    }

    public TkClasspath(final String prefix) {
        super(new Take(){

            @Override
            public Response act(Request request) throws IOException {
                String name = String.format("%s%s", prefix, new RqHref.Base(request).href().path());
                InputStream input = this.getClass().getResourceAsStream(name);
                if (input == null) {
                    throw new HttpException(404, String.format("%s not found in classpath", name));
                }
                return new RsWithBody(input);
            }
        });
    }

    @Override
    public String toString() {
        return "TkClasspath(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TkClasspath)) {
            return false;
        }
        TkClasspath other = (TkClasspath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TkClasspath;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

