/*
 * Decompiled with CFR 0.152.
 */
package org.takes.tk;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.takes.HttpException;
import org.takes.Request;
import org.takes.Response;
import org.takes.Take;
import org.takes.rq.RqHref;
import org.takes.rs.RsWithBody;
import org.takes.tk.TkWrap;

public final class TkFiles
extends TkWrap {
    public TkFiles(String base) {
        this(new File(base));
    }

    public TkFiles(final File base) {
        super(new Take(){

            @Override
            public Response act(Request request) throws IOException {
                File file = new File(base, new RqHref.Base(request).href().path());
                if (!file.exists()) {
                    throw new HttpException(404, String.format("%s not found", file.getAbsolutePath()));
                }
                return new RsWithBody(Files.newInputStream(file.toPath(), new OpenOption[0]));
            }
        });
    }

    @Override
    public String toString() {
        return "TkFiles(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TkFiles)) {
            return false;
        }
        TkFiles other = (TkFiles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TkFiles;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

