/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.exceptions;

import com.github.damianwajser.exceptions.RestException;
import com.github.damianwajser.exceptions.model.ExceptionDetail;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

public final class ExceptionFactory {
    private static Map<HttpStatus, Class<RestException>> exceptionCache = new ConcurrentHashMap<HttpStatus, Class<RestException>>();

    public static RestException getException(List<ExceptionDetail> details, HttpStatus status) throws ReflectiveOperationException {
        Class<RestException> exception = exceptionCache.get(status);
        if (exception == null) {
            exception = new Reflections(RestException.class.getPackage().getName(), new Scanner[0]).getTypesAnnotatedWith(ResponseStatus.class).stream().filter(c -> c.getAnnotation(ResponseStatus.class).code().equals((Object)status)).map(c -> c).findFirst().orElse(RestException.class);
            exceptionCache.put(status, exception);
        }
        return exception.getDeclaredConstructor(List.class).newInstance(details);
    }
}

