/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.exceptions;

import com.github.damianwajser.exceptions.model.ErrorMessage;
import com.github.damianwajser.exceptions.model.ExceptionDetail;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.ResponseStatus;

public abstract class RestException
extends Exception {
    private static final long serialVersionUID = -5157622261482152458L;
    protected final List<ExceptionDetail> details;

    public RestException(List<ExceptionDetail> details) {
        Assert.notNull(details, (String)"details can't be null");
        this.details = details;
    }

    public RestException(ExceptionDetail detail) {
        this(Arrays.asList(detail));
        Assert.notNull((Object)detail, (String)"detail can't be null");
    }

    public RestException(String errorCode, String errorMessage, Optional<Object> errorDetail) {
        this(new ExceptionDetail(errorCode, errorMessage, errorDetail));
    }

    public List<ExceptionDetail> getDetails() {
        return this.details;
    }

    public ErrorMessage getErrorMessage(HttpServletRequest request) {
        return new ErrorMessage(this.getDetails(), request);
    }

    public HttpStatus getHttpCode() {
        return this.getHttpCode(this.getClass());
    }

    private HttpStatus getHttpCode(Class<? extends RestException> ex) {
        ResponseStatus rs = ex.getAnnotation(ResponseStatus.class);
        if (rs != null) {
            return rs.code();
        }
        return this.getHttpCode(ex.getSuperclass());
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
        aOutputStream.defaultWriteObject();
    }
}

