/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.exceptions.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.damianwajser.exceptions.model.ExceptionDetail;
import java.time.LocalDateTime;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorMessage.class);
    @JsonProperty(value="details")
    private List<ExceptionDetail> details;
    private String timestamp;
    @JsonProperty(value="path")
    private String path;

    public ErrorMessage(List<ExceptionDetail> details, HttpServletRequest request) {
        this(details, Encode.forJava((String)request.getRequestURI()));
    }

    @JsonCreator
    private ErrorMessage(@JsonProperty(value="details") List<ExceptionDetail> details, @JsonProperty(value="path") String path) {
        this.details = details;
        this.path = path;
        this.timestamp = LocalDateTime.now().toString();
        LOGGER.debug("Create Error Message: {}", (Object)this);
    }

    public List<ExceptionDetail> getDetails() {
        return this.details;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }
}

