/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.exceptions.model;

import com.fasterxml.jackson.annotation.JsonAlias;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.springframework.util.Assert;

public class ExceptionDetail
implements Serializable {
    private static final long serialVersionUID = 1905128741950251207L;
    @JsonAlias(value={"error_code", "errorCode"})
    private String errorCode;
    @JsonAlias(value={"error_detail", "errorDetail"})
    private Optional<Object> errorDetail;
    @JsonAlias(value={"error_message", "errorMessage"})
    private String errorMessage;
    @JsonAlias(value={"meta_data", "metaData"})
    private Map<String, Object> metaData;

    public ExceptionDetail() {
    }

    public ExceptionDetail(String errorCode, String errorMessage, Optional<Object> detail) {
        Assert.notNull((Object)errorCode, (String)"errorCode dont be null");
        Assert.notNull((Object)errorMessage, (String)"errorMessage dont be null");
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.errorDetail = detail;
        this.metaData = new HashMap<String, Object>();
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setMetaData(String key, Object value) {
        this.metaData.put(key, value);
    }

    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public Optional<Object> getErrorDetail() {
        return this.errorDetail;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        aInputStream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
        aOutputStream.defaultWriteObject();
    }
}

