/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.web.filters;

import com.github.damianwajser.web.configuration.PropertiesHttpFixer;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"spring.commons.http.fixer.enabled"}, havingValue="true", matchIfMissing=true)
public class FixHttpPostFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixHttpPostFilter.class);
    @Autowired
    private PropertiesHttpFixer props;

    public void destroy() {
        LOGGER.debug("destroy filter");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (httpRequest.getMethod().equalsIgnoreCase("POST")) {
            httpServletResponse.setStatus(HttpStatus.CREATED.value());
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.debug("innit filter");
    }
}

