/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.idempotency.configuration;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.github.damianwajser.idempotency.generators.DefaultIdempotencyKeyGenerator;
import com.github.damianwajser.idempotency.generators.IdempotencyKeyGenerator;
import com.github.damianwajser.idempotency.utils.HeadersUtil;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.owasp.encoder.Encode;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class IdempotencyEndpoint {
    private String endpoint;
    private Set<HttpMethod> methods;
    private final IdempotencyKeyGenerator<Object> genarator;

    public IdempotencyEndpoint(String endpoint, Set<HttpMethod> methods) {
        this(endpoint, methods, new DefaultIdempotencyKeyGenerator());
    }

    public IdempotencyEndpoint(String endpoint, Set<HttpMethod> methods, IdempotencyKeyGenerator<Object> generator) {
        this.methods = methods;
        this.endpoint = endpoint;
        this.genarator = generator;
        Assert.notNull(generator, (String)"Genenerator cant be null");
    }

    public String generateKey(HttpServletRequest request) throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        String reqStr = IOUtils.toString((Reader)request.getReader());
        Object req = null;
        Class<?> clazz = this.getGenericTypeClass(this.genarator.getClass());
        if (!StringUtils.isEmpty((Object)reqStr)) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            mapper.setVisibility((VisibilityChecker)VisibilityChecker.Std.defaultInstance().withFieldVisibility(JsonAutoDetect.Visibility.ANY));
            req = mapper.readValue(reqStr, clazz);
        } else {
            req = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return this.genarator.generateKey(new HeadersUtil().getHeaders(request), HttpMethod.valueOf((String)request.getMethod()), Encode.forJava((String)request.getRequestURI()), req);
    }

    private Class<?> getGenericTypeClass(Class<?> clazz) {
        try {
            String className = ((ParameterizedType)clazz.getGenericInterfaces()[0]).getActualTypeArguments()[0].getTypeName();
            return Class.forName(className);
        }
        catch (Exception e) {
            throw new IllegalStateException("Class is not parametrized with generic type!!! Please use extends <> ");
        }
    }

    public boolean isAppicable(HttpMethod httpMethod) {
        return this.methods.contains(httpMethod);
    }
}

