/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"spring.commons.logger.duration.request.enabled"}, havingValue="true")
public class StatsFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatsFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.debug("init stats filter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        long time = System.currentTimeMillis();
        try {
            chain.doFilter(req, resp);
        }
        catch (Throwable throwable) {
            time = System.currentTimeMillis() - time;
            HttpServletRequest request = (HttpServletRequest)req;
            String uri = Encode.forJava((String)request.getRequestURI());
            LOGGER.info("{} {}: {} ms", new Object[]{request.getMethod(), uri, time});
            throw throwable;
        }
        time = System.currentTimeMillis() - time;
        HttpServletRequest request = (HttpServletRequest)req;
        String uri = Encode.forJava((String)request.getRequestURI());
        LOGGER.info("{} {}: {} ms", new Object[]{request.getMethod(), uri, time});
    }
}

