/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.filter;

import java.io.IOException;
import java.util.Enumeration;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@Order(value=-2147483648)
public abstract class MDCFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MDCFilter.class);
    @Value(value="${logstash.trace.id.key:X-Trace-Id}")
    private String traceId;
    @Value(value="${logstash.appName:test}")
    private String appName;

    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.debug("inicializando Filtro");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            MDC.put((String)"clientIp", (String)request.getRemoteAddr());
            MDC.put((String)"appName", (String)this.appName);
            if (HttpServletRequest.class.isAssignableFrom(request.getClass())) {
                MDC.put((String)"requestId", (String)this.requestId((HttpServletRequest)request));
                Enumeration headers = ((HttpServletRequest)request).getHeaderNames();
                while (headers.hasMoreElements()) {
                    String headerName = (String)headers.nextElement();
                    String headerValue = ((HttpServletRequest)request).getHeader(headerName);
                    if (headerValue == null || !headerName.toUpperCase().startsWith("X-")) continue;
                    MDC.put((String)headerName, (String)headerValue);
                }
            }
            chain.doFilter(request, response);
        }
        finally {
            MDC.clear();
        }
    }

    public void destroy() {
        MDC.clear();
    }

    protected String requestId(HttpServletRequest request) {
        String traceValue = request.getHeader(this.traceId);
        if (StringUtils.isEmpty((Object)traceValue)) {
            LOGGER.warn("Request Id not present in request,one autogenerated, please configure your api gateway to generate trace-id");
            traceValue = UUID.randomUUID().toString();
        }
        return traceValue;
    }
}

