/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.configuration;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.damianwajser.filter.MDCFilter;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import net.logstash.logback.appender.LogstashTcpSocketAppender;
import net.logstash.logback.encoder.LogstashEncoder;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.CommonsRequestLoggingFilter;

@Configuration
@EnableConfigurationProperties
@ConfigurationProperties(prefix="logstash")
public class LogstashConfiguration {
    @Value(value="${logstash.destination:localhost:5000}")
    private String destination;
    @Value(value="${logstash.appName:test}")
    private String appName;
    @Value(value="${logstash.maxPayload:16000}")
    private Integer maxPayLoad;
    private Map<String, String> customFields;

    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    @PostConstruct
    public void init() {
        ObjectMapper mapper = new ObjectMapper();
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        LoggerContext loggerContext = rootLogger.getLoggerContext();
        Logger log = loggerContext.getLogger(LogstashConfiguration.class);
        log.info("Configurate  Logger, destination: {}", (Object)this.destination);
        if (this.destination != null && !this.destination.equals("")) {
            LogstashTcpSocketAppender socketAppender = new LogstashTcpSocketAppender();
            socketAppender.setName("logstash");
            socketAppender.setContext((Context)loggerContext);
            socketAppender.addDestination(this.destination);
            LogstashEncoder encoder = new LogstashEncoder();
            encoder.setContext((Context)loggerContext);
            try {
                this.addcustomField("app_name", this.appName);
                encoder.setCustomFields(mapper.writeValueAsString(this.customFields));
            }
            catch (JsonProcessingException e) {
                encoder.setCustomFields("{ \"app_name\": \"" + this.appName + "\" }");
            }
            encoder.start();
            socketAppender.setEncoder((Encoder)encoder);
            socketAppender.start();
            AsyncAppender asyncAppender = new AsyncAppender();
            asyncAppender.addAppender((Appender)socketAppender);
            asyncAppender.start();
            rootLogger.addAppender((Appender)asyncAppender);
        }
    }

    private void addcustomField(String string, String value) {
        if (this.getCustomFields() == null) {
            this.setCustomFields(new HashMap<String, String>());
        }
        this.getCustomFields().put(string, value);
    }

    @Bean
    public Filter logFilter() {
        CommonsRequestLoggingFilter filter = new CommonsRequestLoggingFilter();
        filter.setIncludeQueryString(true);
        filter.setIncludePayload(true);
        filter.setMaxPayloadLength(this.maxPayLoad.intValue());
        return filter;
    }

    @Bean
    public Filter mdcFilter() {
        return new MDCFilter(){

            @Override
            public Map<String, String> getProperties() {
                return new HashMap<String, String>();
            }
        };
    }
}

