/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.validator.constraint;

import java.util.Arrays;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintValidatorContext;
import org.springframework.http.HttpMethod;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class AbstractConstraint {
    protected HttpMethod[] excludes;
    protected boolean isNulleable;

    protected abstract boolean hasError(Object var1, ConstraintValidatorContext var2);

    protected Optional<HttpServletRequest> getCurrentHttpRequest() {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes()).filter(requestAttributes -> ServletRequestAttributes.class.isAssignableFrom(requestAttributes.getClass())).map(requestAttributes -> (ServletRequestAttributes)requestAttributes).map(ServletRequestAttributes::getRequest);
    }

    protected Optional<HttpMethod> getCurrentHttpMethod() {
        return this.getCurrentHttpRequest().map(r -> HttpMethod.resolve((String)r.getMethod()));
    }

    protected boolean isExcluded() {
        Optional<HttpMethod> method = this.getCurrentHttpMethod();
        return method.isPresent() ? Arrays.asList(this.excludes).contains(method.get()) : Boolean.FALSE.booleanValue();
    }

    public boolean isValid(Object field, ConstraintValidatorContext cxt) {
        boolean isValid = true;
        if (!this.isExcluded()) {
            if (field != null) {
                isValid = !this.hasError(field, cxt);
            } else if (!this.isNulleable) {
                isValid = false;
            }
        }
        return isValid;
    }
}

