/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.validator.constraint.cards;

import com.github.damianwajser.validator.annotation.cards.CardExpiration;
import com.github.damianwajser.validator.constraint.AbstractConstraint;
import com.github.damianwajser.validator.interfaces.CardExpirable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class ExpirationCardConstraint
extends AbstractConstraint
implements ConstraintValidator<CardExpiration, Object> {
    CardExpiration.YearFormat yearFormat;

    public void initialize(CardExpiration field) {
        this.excludes = field.excludes();
        this.yearFormat = field.yearFormat();
    }

    @Override
    protected boolean hasError(Object field, ConstraintValidatorContext cxt) {
        Class<?> clazz;
        boolean result = true;
        if (field != null && CardExpirable.class.isAssignableFrom(clazz = field.getClass())) {
            CardExpirable expirable = (CardExpirable)field;
            result = !this.isValidExpirable(expirable);
        }
        return result;
    }

    private boolean isValidExpirable(CardExpirable expirable) {
        String dateStr = expirable.getExpirationMonth() + "-" + expirable.getExpirationYear();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(this.getPattern());
            sdf.setLenient(false);
            Date date = sdf.parse(dateStr);
            return date.after(new Date());
        }
        catch (ParseException e) {
            return false;
        }
    }

    private String getPattern() {
        String format;
        switch (this.yearFormat) {
            case TWO_DIGITS: {
                format = "MM-YY";
                break;
            }
            case FOUR_DIGIT: {
                format = "MM-YYYY";
                break;
            }
            default: {
                format = null;
            }
        }
        return format;
    }
}

