/*
 * Decompiled with CFR 0.152.
 */
package com.github.damianwajser.validator.constraint.global;

import com.github.damianwajser.validator.annotation.global.Size;
import com.github.damianwajser.validator.constraint.AbstractConstraint;
import java.util.Collection;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.http.HttpMethod;

public class SizeConstraint
extends AbstractConstraint
implements ConstraintValidator<Size, Object> {
    int max;
    int min;

    public void initialize(Size field) {
        this.initialize(field.excludes(), field.max(), field.min(), field.isNulleable());
    }

    public SizeConstraint initialize(HttpMethod[] excludes, int max, int min, boolean isNulleable) {
        this.excludes = excludes;
        this.isNulleable = isNulleable;
        this.max = max;
        this.min = min;
        return this;
    }

    @Override
    protected boolean hasError(Object field, ConstraintValidatorContext cxt) {
        boolean hasError = true;
        if (field != null) {
            Class<?> clazz = field.getClass();
            if (String.class.isAssignableFrom(clazz)) {
                hasError = this.hasErrorSize(((String)field).length());
            } else if (Collection.class.isAssignableFrom(clazz)) {
                hasError = this.hasErrorSize(((Collection)field).size());
            }
        } else {
            hasError = this.min > 0;
        }
        return hasError;
    }

    private boolean hasErrorSize(int size) {
        return size < this.min || size > this.max;
    }
}

